// The White House from Independence Day.

#include "colors.inc"
#include "textures.inc"

global_settings { ambient_light rgb<127,141,145>/512
                  assumed_gamma 2.2
                  }

// Initial Declarations

#declare WindowScale = <1,1,1/3>

#declare Leaf_Texture = texture { pigment { rgb<51,121,54>/255}
                                  finish { ambient 0.5
                                           //brilliance 0.5
                                           phong 0.1
                                           phong_size 10
                                           }
                                  }

#declare Black_Lamp = texture { pigment { Gray30}
                                finish { ambient 0.2
                                         specular 0.1
                                         roughness 0.2
                                         }
                                }

#declare Lamp_Glass = texture { pigment { Gray90 filter 0.9}
                                finish { ambient 0.4
                                         specular 0.6
                                         roughness 0.06
                                         }
                                }

#declare White_Texture = texture { pigment { White}
                                   finish { ambient 0.4
                                            specular 0.2
                                            roughness 0.1
                                            }
                                   }

#declare Window_Glass = texture { pigment { Gray90 filter 0.9}
                                 finish { ambient 0.5
                                          specular 0.1
                                          roughness 0.01
                                          reflection 0.3
                                          }
                                 }

#declare CHeight = 28

#declare CWidth = 1.5

#declare CRadius = -25

#declare O = <0,0,0>

#declare Count = 0

#declare Count2 = 0

#declare C1 = 0

#declare CCount = 0

#declare NCCount = 0

// Bush Beneath Lamp

#declare Angle = 45
#declare LeafNo = 3000
#declare Count = 0
#declare BushSeed = seed(1)
#declare Size = 10
#declare LeafSize = 1
#declare Roundness = 70

#include "Bush.inc"

#declare Potted_Bush = Bush

// Tree

#declare Height = 1280

#declare THeight = 256

#declare TopAngle = 120

#declare GenAngle = 5

#declare NLeaves = 16 //24

#declare RLeaves = seed(12345)

#declare LeafSze = 4

#declare NSBrncs = 8

#declare RSBrncs = seed(54321)

#declare NBrancs = 30 //120

#declare RBrancs = seed(15243)

#declare VaryDeg = 5

#declare VaryAmt = 3

#declare Trunk = 0

#declare Count = 0

#include "tree.inc"

#declare TreeRight = Tree

// Tree 2 / Bush

#declare Height = 768

#declare THeight = 128

#declare TopAngle = 120

#declare GenAngle = 20

#declare NLeaves = 48

#declare LeafSze = 1

#declare RLeaves = seed(12)

#declare NSBrncs = 12

#declare RSBrncs = seed(13)

#declare NBrancs = 48

#declare RBrancs = seed(14)

#declare VaryDeg = 1.25

#declare VaryAmt = 4

#declare Trunk = 0

#declare Count = 0

#include "tree.inc"

#declare TreeLeft = object { Tree}

// Tree

#declare Height = 512

#declare THeight = 256

#declare TopAngle = 90

#declare GenAngle = 5

#declare NLeaves = 32

#declare RLeaves = seed(12)

#declare LeafSze = 2

#declare NSBrncs = 6

#declare RSBrncs = seed(13)

#declare NBrancs = 15

#declare RBrancs = seed(14)

#declare VaryDeg = 15

#declare VaryAmt = 4.25

#include "tree.inc"

#declare BaseTree = Tree

// Main Declarations

/*#declare Leaf = mesh { smooth_triangle {<0,0,8>,<0.5,0.4,0.1>,
                                        <0,0,6>,<0.5,0.4,0.0>,
                                        <2,0,6>,<-.3,1.0,0.0>
                                        }
                       smooth_triangle {<0,0,4>,<0.5,0.4,-.1>,
                                        <0,0,6>,<0.5,0.4,0.0>,
                                        <2,0,6>,<-.3,1.0,0.0>
                                        }
                       smooth_triangle {<0,0,8>*<-1,1,1>,<0.5,0.4,0.1>*<-1,1,1>,
                                        <0,0,6>*<-1,1,1>,<0.5,0.4,0.0>*<-1,1,1>,
                                        <2,0,6>*<-1,1,1>,<-.3,1.0,0.0>*<-1,1,1>
                                        }
                       smooth_triangle {<0,0,4>*<-1,1,1>,<0.5,0.4,-.1>*<-1,1,1>,
                                        <0,0,6>*<-1,1,1>,<0.5,0.4,0.0>*<-1,1,1>,
                                        <2,0,6>*<-1,1,1>,<-.3,1.0,0.0>*<-1,1,1>
                                        }
                       triangle {<0,0,0>,<0.1,0,4.1>,<-.1,0,4.1>}
                       texture { Leaf_Texture}
                       scale 2
                       hierarchy
                       }*/

#declare Lamp = union  { mesh { triangle {<-4,0,-4>,      // The Lamps on the Front
                                          <-4,0,4>,       // The Top Bit
                                          <0,3,0>
                                          }
                                triangle {<-4,0,-4>,
                                          <4,0,-4>,
                                          <0,3,0>
                                          }
                                triangle {<-4,0,-4>,
                                          <4,0,-4>,
                                          <0,3,0>
                                          }
                                triangle {<4,0,-4>,
                                          <4,0,4>,
                                          <0,3,0>
                                          }
                                triangle {<-2,0,-2>,      // The Sticky-off bit on the top
                                          <2,0,-2>,
                                          <0,5,0>
                                          }
                                triangle {<2,0,-2>,
                                          <2,0,2>,
                                          <0,5,0>
                                          }
                                triangle {<2,0,2>,
                                          <-2,0,2>,
                                          <0,5,0>
                                          }
                                triangle {<-2,0,2>,
                                          <-2,0,-2>,
                                          <0,5,0>
                                          }
                                triangle {<-3,-6,-3>,     // The Bottom Black Bit
                                          <3,-6,-3>,
                                          <0,-7,0>
                                          }
                                triangle {<3,-6,-3>,
                                          <3,-6,3>
                                          <0,-7,0>
                                          }
                                triangle {<3,-6,3>,
                                          <-3,-6,3>,
                                          <0,-7,0>
                                          }
                                triangle {<-3,-6,3>,
                                          <-3,-6,-3>,
                                          <0,-7,0>
                                          }
                                triangle {<-1,-6,-1>,      // The Bit that hangs off the base
                                          <1,-6,-1>,
                                          <0,-9,0>
                                          }
                                triangle {<-1,-6,-1>,
                                          <-1,-6,1>,
                                          <0,-9,0>
                                          }
                                triangle {<1,-6,-1>,
                                          <1,-6,1>,
                                          <0,-9,0>
                                          }
                                triangle {<1,-6,1>,
                                          <-1,-6,1>,
                                          <0,-9,0>
                                          }
                                texture { Black_Lamp}
                                }
                         sphere {<0,5,0>,1
                                 texture { Black_Lamp}
                                 }
                         mesh { triangle {<-3.5,0,-3.5>,          // The Glass Bit
                                          <3.5,0,-3.5>,           // Front
                                          <-2.75,-6,-2.75>
                                          }
                                triangle {<-2.75,-6,-2.75>,
                                          <2.75,-6,-2.75>,
                                          <3.5,0,-3.5>
                                          }
                                triangle {<3.5,0,-3.5>,           // Right Side
                                          <3.5,0,3.5>,
                                          <2.75,-6,-2.75>
                                          }
                                triangle {<2.75,-6,-2.75>,
                                          <2.75,-6,2.75>,
                                          <3.5,0,3.5>
                                          }
                                triangle {<3.5,0,3.5>,            // Back Side ( no pun intended )
                                          <-3.5,0,3.5>,
                                          <2.75,-6,2.75>
                                          }
                                triangle {<2.75,-6,2.75>,
                                          <-2.75,-6,2.75>,
                                          <-3.5,0,3.5>
                                          }
                                triangle {<-3.5,0,3.5>,           // Left Side ( no pun at all, oh well)
                                          <-3.5,0,-3.5>,
                                          <-2.75,-6,2.75>
                                          }
                                triangle {<-2.75,-6,2.75>,
                                          <-2.75,-6,-2.75>,
                                          <-3.5,0,-3.5>
                                          }
                                texture { Lamp_Glass}
                                }
                         light_source {<0,-3,0> color rgb<253,225,140>/(512+200)
                                       fade_distance 5
                                       fade_power 2
                                       atmosphere off
                                       }
                         scale <1/4,1/3,1/4>
                         }

#declare Curtains = union { bicubic_patch { type 1
                                            flatness 0.2
                                            u_steps 3
                                            v_steps 3
                                            <-1*CWidth,1*(CHeight*(17/32))/2,0.2>  , <-1*CWidth+(CWidth*0.25),1*(CHeight*(17/32))/2,0.6>  , <-1*CWidth+(CWidth*0.5),1*(CHeight*(17/32))/2,0.2>  ,  <-1*CWidth+(CWidth*1),1*(CHeight*(17/32))/2,0.6>  ,
                                            <-1*CWidth,5*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.25),5*(CHeight*(17/32))/12,0.6> , <-1*CWidth+(CWidth*0.5),5*(CHeight*(17/32))/12,0.2>  , <-1*CWidth+(CWidth*1),5*(CHeight*(17/32))/12,0.6> ,
                                            <-1*CWidth,3*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.2),3*(CHeight*(17/32))/8,0.6>  , <-1*CWidth+(CWidth*0.40),3*(CHeight*(17/32))/8,0.2>  ,  <-1*CWidth+(CWidth*0.70),3*(CHeight*(17/32))/8,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.15),1*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.30),1*(CHeight*(17/32))/4,0.2>  ,  <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/4,0.6>
                                            }
                            bicubic_patch { type 1
                                            flatness 0.2
                                            u_steps 3
                                            v_steps 3
                                            <-1*CWidth,1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.15),1*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.30),1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/4,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.20),1*(CHeight*(17/32))/8,0.6>  , <-1*CWidth+(CWidth*0.40),1*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.60),1*(CHeight*(17/32))/8,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.20),1*(CHeight*(17/32))/12,0.6> , <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.65),1*(CHeight*(17/32))/12,0.6> ,
                                            <-1*CWidth,0*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.20),0*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.45),0*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.6),0*(CHeight*(17/32))/4,0.6>
                                            }
                            bicubic_patch { type 1
                                            flatness 0.2
                                            u_steps 3
                                            v_steps 3
                                            <-1*CWidth,1*(CHeight*(17/32))/2,0.2>  , <-1*CWidth+(CWidth*0.25),1*(CHeight*(17/32))/2,0.6>  , <-1*CWidth+(CWidth*0.5),1*(CHeight*(17/32))/2,0.2>  ,  <-1*CWidth+(CWidth*1),1*(CHeight*(17/32))/2,0.6>  ,
                                            <-1*CWidth,5*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.25),5*(CHeight*(17/32))/12,0.6> , <-1*CWidth+(CWidth*0.5),5*(CHeight*(17/32))/12,0.2>  , <-1*CWidth+(CWidth*1),5*(CHeight*(17/32))/12,0.6> ,
                                            <-1*CWidth,3*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.2),3*(CHeight*(17/32))/8,0.6>  , <-1*CWidth+(CWidth*0.40),3*(CHeight*(17/32))/8,0.2>  ,  <-1*CWidth+(CWidth*0.70),3*(CHeight*(17/32))/8,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.15),1*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.30),1*(CHeight*(17/32))/4,0.2>  ,  <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/4,0.6>
                                            scale <-1,1,1>
                                            }
                            bicubic_patch { type 1
                                            flatness 0.2
                                            u_steps 3
                                            v_steps 3
                                            <-1*CWidth,1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.15),1*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.30),1*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/4,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.20),1*(CHeight*(17/32))/8,0.6>  , <-1*CWidth+(CWidth*0.40),1*(CHeight*(17/32))/8,0.2>  , <-1*CWidth+(CWidth*0.60),1*(CHeight*(17/32))/8,0.6>  ,
                                            <-1*CWidth,1*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.20),1*(CHeight*(17/32))/12,0.6> , <-1*CWidth+(CWidth*0.45),1*(CHeight*(17/32))/12,0.2> , <-1*CWidth+(CWidth*0.65),1*(CHeight*(17/32))/12,0.6> ,
                                            <-1*CWidth,0*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.20),0*(CHeight*(17/32))/4,0.6>  , <-1*CWidth+(CWidth*0.45),0*(CHeight*(17/32))/4,0.2>  , <-1*CWidth+(CWidth*0.6),0*(CHeight*(17/32))/4,0.6>
                                            scale <-1,1,1>
                                            }
                            pigment { rgbt<248,169,104,150>/255}
                            }

#declare Window = union { union { box {<(-1*CWidth)-0.7,0,-1>,<(-1*CWidth)-0.3,(1*(CHeight*(17/32))/2)+0.7,2>}
                                  box {<(-1*CWidth)-0.7,0,-1>,<(1*CWidth)+0.7,0.7,2>}
                                  box {<(1*CWidth)+0.3,0,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+0.7,2>}
                                  box {<(-1*CWidth)-0.7,(1*(CHeight*(17/32))/2)+0.7,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+1.2,2>}
                                  scale WindowScale
                                  translate <0,0,(2/3)*CRadius>
                                  //pigment { Green}
                                  //rotate y*((180/5)*-1)
                                  }
                          object { Curtains
                                   translate <0,0,(2/3)*CRadius>
                                   }
                          union { box {<(-1*CWidth),0,0>,<CWidth,1*(CHeight*(17/32))/2,1>
                                       texture { Window_Glass}
                                       }
                                  cylinder {<(-1*CWidth),1*(1*(CHeight*(17/32))/2)/4,0>,
                                            <CWidth,1*(1*(CHeight*(17/32))/2)/4,0>,
                                            0.04
                                            }
                                  cylinder {<(-1*CWidth),2*(1*(CHeight*(17/32))/2)/4,0>,
                                            <CWidth,2*(1*(CHeight*(17/32))/2)/4,0>,
                                            0.04
                                            }
                                  cylinder {<(-1*CWidth),3*(1*(CHeight*(17/32))/2)/4,0>,
                                            <CWidth,3*(1*(CHeight*(17/32))/2)/4,0>,
                                            0.04
                                            }
                                  cylinder {<(1*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                            <(1*(-2*CWidth)/3)+CWidth,0,0>,
                                            0.04
                                            }
                                  cylinder {<(2*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                            <(2*(-2*CWidth)/3)+CWidth,0,0>,
                                            0.04
                                            }
                                  light_source {<(-1*CWidth)/2,2*(1*(CHeight*(17/32))/2)/3,4>
                                                color rgb<650,375,140>/(512+200)
                                                fade_power 2
                                                fade_distance 8
                                                }
                                  scale WindowScale
                                  translate <0,0,(2/3)*CRadius>
                                  }
                          union { intersection { cylinder {<0,0,0>,
                                                           <-0.4,0,0>,
                                                           1
                                                           scale <1,3,1>
                                                           translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                           scale WindowScale
                                                           translate <0,0,(2/3)*CRadius>
                                                           }
                                                 box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                      <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                      scale WindowScale
                                                      translate <0,0,(2/3)*CRadius>
                                                      }
                                                 //pigment { Red}
                                                 //translate <2,0,-5>
                                                 }
                                  intersection { cylinder {<0,0,0>,
                                                           <-0.4,0,0>,
                                                           1
                                                           scale <1,3,1>
                                                           translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                           scale WindowScale
                                                           translate <0,0,(2/3)*CRadius>
                                                           }
                                                 box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                      <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                      scale WindowScale
                                                      translate <0,0,(2/3)*CRadius>
                                                      }
                                                 //pigment { Red}
                                                 scale <-1,1,1>
                                                 }
                                  box {<(-1*CWidth)-1.4,(1*(CHeight*(17/32))/2)+1.2+2,-0.8>,
                                       <(1*CWidth)+1.4,(1*(CHeight*(17/32))/2)+1.2+2.4,2>
                                       scale WindowScale
                                       translate <0,0,(2/3)*CRadius>
                                       //pigment { Red}
                                       }
                                  union { intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                              <0,-0.2,2>
                                                              }
                                                         plane {<0,0,-1>,0
                                                                rotate y*20
                                                                translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                }
                                                         rotate z*25
                                                         scale WindowScale
                                                         translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                         }
                                          intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                              <0,-0.2,2>
                                                              }
                                                         plane {<0,0,-1>,0
                                                                rotate y*20
                                                                translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                }
                                                         rotate z*25
                                                         scale WindowScale
                                                         translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                         scale <-1,1,1>
                                                         }
                                          //pigment { Red}
                                          }
                                  //translate <0,0,(2/3)*CRadius>
                                  }
                          }

#declare Window2 = union { union { box {<(-1*CWidth)-0.7,0,-1>,<(-1*CWidth)-0.3,(1*(CHeight*(17/32))/2)+0.7,2>}
                                   box {<(-1*CWidth)-1.2,0,-1.3>,<(1*CWidth)+1.2,0.7,2>}
                                   box {<(1*CWidth)+0.3,0,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+0.7,2>}
                                   box {<(-1*CWidth)-1.2,(1*(CHeight*(17/32))/2)+0.7,-1.3>,<(1*CWidth)+1.2,(1*(CHeight*(17/32))/2)+1.2,2>}
                                   scale WindowScale
                                   translate <0,0,(2/3)*CRadius>
                                   }
                           object { Curtains
                                    translate <0,0,(2/3)*CRadius>
                                    }
                           union { box {<(-1*CWidth),0,0>,<CWidth,1*(CHeight*(17/32))/2,1>
                                        texture { Window_Glass}
                                        }
                                   cylinder {<(-1*CWidth),1*(1*(CHeight*(17/32))/2)/4,0>,
                                             <CWidth,1*(1*(CHeight*(17/32))/2)/4,0>,
                                             0.04
                                             }
                                   cylinder {<(-1*CWidth),2*(1*(CHeight*(17/32))/2)/4,0>,
                                             <CWidth,2*(1*(CHeight*(17/32))/2)/4,0>,
                                             0.04
                                             }
                                   cylinder {<(-1*CWidth),3*(1*(CHeight*(17/32))/2)/4,0>,
                                             <CWidth,3*(1*(CHeight*(17/32))/2)/4,0>,
                                             0.04
                                             }
                                   cylinder {<(1*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                             <(1*(-2*CWidth)/3)+CWidth,0,0>,
                                             0.04
                                             }
                                   cylinder {<(2*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                             <(2*(-2*CWidth)/3)+CWidth,0,0>,
                                             0.04
                                             }
                                   light_source {<(-1*CWidth)/2,2*(1*(CHeight*(17/32))/2)/3,4>
                                                 color rgb<650,375,240>/(512)//+100)
                                                 fade_power 2
                                                 fade_distance 8
                                                 }
                                   scale WindowScale
                                   translate <0,0,(2/3)*CRadius>
                                   }
                           translate <0,(CHeight*(17/32))+1.3,0>
                           }

#declare Column = union { cylinder { <0,CHeight,0>,<0,0,0>,CWidth}
                          box {<-(CWidth+0.5),CHeight,-(CWidth+0.5)>,<CWidth+0.5,CHeight+0.2,CWidth+0.5>}
                          torus { CWidth+0.2,0.4
                                  translate <0,0.4,0>
                                  }
                          torus { CWidth+0.2,0.4
                                  }
                          box {<-(CWidth+0.6),-2,-(CWidth+0.6)>,<(CWidth+0.6),-0.2,(CWidth+0.6)>}
  #while (CCount<4)
    #declare CCount = CCount + 1
                          union { cylinder { <1.5,CHeight,0>,<1.5,CHeight-0.2,0>,(sqrt(2*pow((CWidth+0.5),2))-CWidth)/1.5}
                                  sphere { <1.5,CHeight-0.4,0>,(sqrt(2*pow((CWidth+0.5),2))-CWidth)/1.5}
                                  rotate y*(45+(90*CCount))
                                  }
  #end
  #declare CCount = 0
                          texture { White_Texture}
                          }

#declare Railings = union { box {<-CWidth-2,-0.4,-0.1>,<CWidth+2,-0.2,0.1>}
  #while (Count2<15)
                            cylinder {<-CWidth-1.5+((CWidth/15)*Count2*4),-0.2,0>,
                                      <-CWidth-1.5+((CWidth/15)*Count2*4),-2.5,0>,
                                      0.07
                                      }
    #declare Count2 = Count2+1
  #end
  #declare Count2 = 0
                            texture { Black_Lamp}
                            }

#declare Thing = lathe { cubic_spline
                         7,
                         <0,0>,<2*((pi*-CRadius)/80)/3,0.5>,<(pi*-CRadius)/80,2>,<5*((pi*-CRadius)/80)/9,3.5>,
                         <(pi*-CRadius)/80,4.25>,<0,4.5>,<0,0>
                         scale <0.7,1,0.7>
                         }

#declare Count = 0

#declare CurvedThings = union {
  #while (Count<8)
                                object { Thing
                                         translate <0,CHeight+6.5,-CRadius+CWidth+1.3-((pi*-CRadius)/80)>
                                         rotate y*(((180/(6+(2/3)))/8)*(Count-3.5))
                                         }
     #declare Count = Count + 1
   #end
                                }

#declare CurvedBlock = difference { cylinder {<0,CHeight+6.5+4.5,0>,
                                              <0,CHeight+7.0,0>,
                                              -CRadius+CWidth+1.5
                                              }
                                    cylinder {<0,CHeight+6.5+4.5,0>,
                                              <0,CHeight+7.0,0>,
                                              -CRadius+CWidth+1.0
                                              }
                                    plane { x, 0
                                            rotate y*(180/30)
                                            }
                                    plane { -x, 0
                                            rotate y*-(180/30)
                                            }
                                    }

#declare Count = 0

#declare TopDist = -((((2/3)*CRadius)-(35*CWidth))+(-CRadius+CWidth+1.0))

#declare LineThings = union {
  #while (Count<8)
                              object { Thing
                                       scale <0.8,1,0.8>
                                       translate <(((TopDist/4)/8)*(Count+0.5-(8*(2/6)))),CHeight+6.5,0>
                                       }
    #declare Count = Count + 1
  #end
  #declare Count = 0
                              }

#declare Block = box {<0,CHeight+6.5,-0.3>,
                      <TopDist/9,CHeight+6.5+4.5,0.3>
                      }

#declare Dust1 = sphere {<0,0,0>,3.1
                         hollow
                         texture { pigment { Clear
                                             quick_color Red
                                             }
                                   halo { dust
                                          dust_type 4
                                          linear
                                          max_value 1.0
                                          spherical_mapping
                                          samples 10
                                          turbulence 0.2
                                          octaves 4
                                          lambda 2
                                          omega 8/12
                                          color_map {[0.0 color rgbft<0.5,0.5,0.5,1.0,1>]
                                                     [0.2 color rgbft<0.5,0.5,0.5,1.0,0.9>]
                                                     [0.3 color rgbft<0.5,0.5,0.5,1.0,0.4>]
                                                     [1.0 color rgbft<0.5,0.5,0.5,1.0,0.2>]
                                                     }
                                          scale 0.9
                                          }
                                   scale 3
                                   }
                         //scale 0.1
                         }

#declare Dust2 = sphere {<0,0,0>,3.1
                         hollow
                         texture { pigment { Clear
                                             quick_color Gray80
                                             }
                                   halo { dust
                                          dust_type 4
                                          linear
                                          max_value 1.0
                                          spherical_mapping
                                          samples 10
                                          turbulence 0.5
                                          octaves 4
                                          lambda 3
                                          omega 7/12
                                          color_map {[0.0 color rgbft<0.5,0.5,0.5,1.0,1>]
                                                     [0.2 color rgbft<0.5,0.5,0.5,1.0,0.9>]
                                                     [0.3 color rgbft<0.5,0.5,0.5,1.0,0.4>]
                                                     [1.0 color rgbft<0.5,0.5,0.5,1.0,0.2>]
                                                     }
                                          scale 0.9
                                          }
                                   scale 2
                                   }
                         //scale 0.1
                         }

#declare Explosion = cylinder {<0,0,0>,<0,10,0>,1.5
                               hollow
                               texture { pigment { Clear
                                                   quick_color rgbf<1,1,1,1>}
                                         halo { emitting
                                                linear
                                                cylindrical_mapping
                                                samples 20
                                                turbulence <0.6,0.1,0.6>
                                                color_map {[0.00 color rgbt<0.02,0.21,0.46,1.00>*00.7]
                                                           [0.45 color rgbt<0.06,0.45,0.96,0.00>*01.5]//60>]
                                                           [0.60 color rgbt<0.26,0.80,0.96,0.00>*02.3]//0.45>]
                                                           [0.70 color rgbt<0.47,0.99,1.00,0.00>*03.5]//25>]
                                                           [1.00 color rgbt<1.00,1.00,1.00,0.00>*16.0]
                                                           }
                                                }
                                         }
                               scale <0.5,1,0.5>
                               }

#declare ShowerSeed = seed(4)
#declare ShowerBits = 3000
#declare Count = 0

#declare Shower = mesh {
  #while (Count < ShowerBits)
    #declare Rotate0 = rand(ShowerSeed)*360
    #declare Rotate1 = (rand(ShowerSeed)*180)-90
    #declare Rotate2 = rand(ShowerSeed)*360
    #declare Translate = rand(ShowerSeed)*2
    #declare Vector1 = vrotate(vrotate(vrotate(<0,0,0>+<0,0,Translate>,
                                               <0,0,Rotate0>),
                                       <Rotate1,0,0>),
                               <0,Rotate2,0>)
    #declare Vector2 = vrotate(vrotate(vrotate(<-0.04,0,0.20>+<0,0,Translate>,
                                               <0,0,Rotate0>),
                                       <Rotate1,0,0>),
                               <0,Rotate2,0>)
    #declare Vector3 = vrotate(vrotate(vrotate(<0.04,0,0.20>+<0,0,Translate>,
                                               <0,0,Rotate0>),
                                       <Rotate1,0,0>),
                               <0,Rotate2,0>)
                         triangle {Vector1,
                                   Vector2,
                                   Vector3
                                   }
    #declare Count = Count + 1
  #end
  #declare Count = 0
                         pigment { color rgbt<0.26,0.80,0.96,0.00>*02.3}
                         finish { ambient 0.9}
                         }

#declare ShowerSeed = seed(4)
#declare ShowerBits = 2500
#declare ShowerHeight = 10
#declare Count = 0

#declare ShowerC = mesh {
  #while (Count < ShowerBits)
    #declare Rotate0 = rand(ShowerSeed)*360
    #declare Rotate1 = (rand(ShowerSeed)*180)-90
    #declare Rotate2 = rand(ShowerSeed)*360
    #declare Translate = rand(ShowerSeed)*0.9
    #declare Vector1 = vrotate(<0,(ShowerHeight/ShowerBits)*Count,0>+
                               vrotate(<0,0,0>+<0,0,Translate>,
                                       <0,0,Rotate0>),
                               <0,Rotate2,0>)
    #declare Vector2 = vrotate(<0,(ShowerHeight/ShowerBits)*Count,0>+
                               vrotate(<-0.04,0,0.20>+<0,0,Translate>,
                                       <0,0,Rotate0>),
                               <0,Rotate2,0>)
    #declare Vector3 = vrotate(<0,(ShowerHeight/ShowerBits)*Count,0>+
                               vrotate(<0.04,0,0.20>+<0,0,Translate>,
                                       <0,0,Rotate0>),
                               <0,Rotate2,0>)
                          triangle {Vector1,
                                    Vector2,
                                    Vector3
                                    }
    #declare Count = Count + 1
  #end
  #declare Count = 0
                          pigment { color rgbt<0.26,0.80,0.96,0.00>*02.3}
                          finish { ambient 0.9}
                          }

#declare AlienFire = union { object { Explosion}
                             object { ShowerC}
                             object { Shower
                                      scale <0.8,1,0.8>
                                      translate <0,2,0>
                                      }
                             light_source {<0,7.5,0> color Gray80}
                             light_source {<0,5,0> color Gray80}
                             light_source {<0,2.5,0> color Gray80}
                             no_shadow
                             }

#declare House_Front = union { 
  #while (NCCount < 6)
                               union { cylinder { <0,CHeight,0>,<0,0,0>,CWidth}
                                       box {<-(CWidth+0.5),CHeight,-(CWidth+0.5)>,<CWidth+0.5,CHeight+0.2,CWidth+0.5>}
                                       torus {CWidth+0.2,0.4
                                              translate <0,0.4,0>
                                              }
                                       torus {CWidth+0.2,0.4
                                              }
                                       box {<-(CWidth+0.6),-2,-(CWidth+0.6)>,<(CWidth+0.6),-0.2,(CWidth+0.6)>}
  #while (CCount<4)
    #declare CCount = CCount + 1
                                       union { cylinder { <1.5,CHeight,0>,<1.5,CHeight-0.2,0>,(sqrt(2*pow((CWidth+0.5),2))-CWidth)/1.5}
                                               sphere { <1.5,CHeight-0.4,0>,(sqrt(2*pow((CWidth+0.5),2))-CWidth)/1.5}
                                               rotate y*(45+(90*CCount))
                                               }
  #end
  #declare CCount = 0
                                       texture { White_Texture}
                                       translate <0,0,CRadius>
                                       rotate y*((180/8)*(NCCount-2.5))
                                       }
    #declare NCCount = NCCount + 1
  #end
  #declare Count = 0
  #declare Count2 = 0
  #while (Count<3)
                               union { box {<-CWidth-2,-0.4,-0.1>,<CWidth+2,-0.2,0.1>}
    #while (Count2<15)
                                       cylinder {<-CWidth-1.5+((CWidth/15)*Count2*4),-0.2,0>,
                                                 <-CWidth-1.5+((CWidth/15)*Count2*4),-2,0>,
                                                 0.07
                                                 }
      #declare Count2 = Count2+1
    #end
    #declare Count2 = 0
                                       translate <0,0,CRadius>
                                       rotate y*((180/8)*(Count-1))
                                       texture { Black_Lamp}
                                       }
    #declare Count = Count +1
  #end
  #declare Count = 0
                               union { cylinder { <0,CHeight+0.2,0>,<0,CHeight+0.4,0>,-CRadius+CWidth+0.5}  // The Bit on to pf the Columns
                                       cylinder { <0,CHeight+0.4,0>,<0,CHeight+0.7,0>,-CRadius+CWidth+0.6}
                                       cylinder { <0,CHeight+0.7,0>,<0,CHeight+1.5,0>,-CRadius+CWidth+0.7}
                                       cylinder { <0,CHeight+1.5,0>,<0,CHeight+4.0,0>,-CRadius+CWidth+0.9}
                                       cylinder { <0,CHeight+3.2,0>,<0,CHeight+4.0,0>,-CRadius+CWidth+1.1}
                                       cylinder { <0,CHeight+3.6,0>,<0,CHeight+4.0,0>,-CRadius+CWidth+1.3}
                                       texture { White_Texture}
                                       }
                               difference { cylinder { <0,CHeight+4.0,0>,<0,CHeight+5.0,0>,-CRadius+CWidth+2.5}
                                            torus { -CRadius+CWidth+2.5,1.0
                                                    translate <0,CHeight+4.0,0>
                                                    }
                                            texture { White_Texture}
                                            }
                               union {
  #while (Count<40)
                                       sphere {<-CRadius+CWidth+2.2,CHeight+4.4,0>,0.4
                                               rotate y*((180/40)*Count)
                                               }
    #declare Count = Count + 1
  #end
  #declare Count = 0
                                       }
                               union { cylinder { <0,CHeight+5.0,0>,<0,CHeight+5.5,0>,-CRadius+CWidth+2.5}
                                       cylinder { <0,CHeight+5.5,0>,<0,CHeight+5.8,0>,-CRadius+CWidth+2.7}
                                       cylinder { <0,CHeight+5.8,0>,<0,CHeight+6.5,0>,-CRadius+CWidth+3.0}
                                       }
                               union {
#declare Count = 1
#while (Count<10)
                                       object { CurvedThings
                                                rotate y*-90
                                                rotate y*-((180/10)*Count)
                                                }
  #declare Count = Count + 2
#end
#declare Count = 0
#while (Count<10)
                                       object { CurvedBlock
                                                rotate y*-90
                                                rotate y*((180/10)*Count)
                                                }
  #declare Count = Count + 2
#end
#declare Count = 0
                                       difference { cylinder {<0,CHeight+6.5+4.5,0>,
                                                              <0,CHeight+7.0+4.5,0>,
                                                              -CRadius+CWidth+1.3
                                                              }
                                                    cylinder {<0,CHeight+6.5+4.0,0>,
                                                              <0,CHeight+7.0+4.8,0>,
                                                              -CRadius+CWidth+1.3-(2*((pi*-CRadius)/80))
                                                              }
                                                    }
                                       }
                               union {
#while (Count<8)
                                       object { LineThings
                                                translate <((TopDist/6)*Count)+(-CRadius+CWidth+1.3),0,0>
                                                }
  #declare Count = Count + 2
#end
#declare Count = 1
#while (Count<8)
                                       object { Block
                                                translate <((TopDist/6)*Count)+(-CRadius+CWidth+1.3),0,0>
                                                }
  #declare Count = Count + 2
#end
                                       box {<(((2/3)*CRadius)-(35*CWidth)),CHeight+6.5+4.5,-0.3>,
                                            <-(-CRadius+CWidth+1.3)/1.2,CHeight+7.0+4.5,0.3>
                                            scale <1.2,1,1>
                                            }
                                       }
#declare Count = 0
                               union {
#while (Count<8)
                                       object { LineThings
                                                translate <((TopDist/6)*Count)+(-CRadius+CWidth+1.3),0,0>
                                                }
  #declare Count = Count + 2
#end
#declare Count = 1
#while (Count<8)
                                       object { Block
                                                translate <((TopDist/6)*Count)+(-CRadius+CWidth+1.3),0,0>
                                                }
  #declare Count = Count + 2
#end
#declare Count = 0
                                       box {<(((2/3)*CRadius)-(35*CWidth)),CHeight+6.5+4.5,-0.3>,
                                            <-(-CRadius+CWidth+1.3)/1.2,CHeight+7.0+4.5,0.3>
                                            scale <1.2,1,1>
                                            }
                                       scale <-1,1,1>
                                       }
                               union { box {<(((2/3)*CRadius)-(35*CWidth)),CHeight+0.2,0>,
                                            <-(((2/3)*CRadius)-(35*CWidth)),CHeight+0.4,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-0.1,CHeight+0.4,-0.1>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+0.1,CHeight+0.7,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-0.2,CHeight+0.7,-0.2>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+0.2,CHeight+1.5,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-0.4,CHeight+1.5,-0.4>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+0.4,CHeight+4.0,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-0.6,CHeight+3.2,-0.6>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+0.6,CHeight+4.0,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-0.8,CHeight+3.6,-0.8>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+0.8,CHeight+4.0,-0.8>
                                            }
                                       scale <1.2,1,1>
                                       }
                               difference { box {<(((2/3)*CRadius)-(35*CWidth))-2.0,CHeight+4.0,-2.0>,
                                                 <-(((2/3)*CRadius)-(35*CWidth))+2.0,CHeight+5.0,5>
                                                 }
                                            cylinder {<(((2/3)*CRadius)-(35*CWidth))-2.1,CHeight+4.0,-2.0>,
                                                      <-(((2/3)*CRadius)-(35*CWidth))+2.1,CHeight+5.0,-2.0>,
                                                      1.0
                                                      }
                                            scale <1.2,1,1>
                                            }
                               union {
#while (Count<80)
                                       sphere {<((-(((2/3)*CRadius)-(35*CWidth))+2.0)+(Count*((2*(((2/3)*CRadius)-(35*CWidth))+2.0)/80)))*1.2,CHeight+4.4,-2.2>,
                                               0.4
                                               }
  #declare Count = Count + 1
#end
#declare Count = 0
                                       scale <1,1,1>
                                       }
                               union { box {<(((2/3)*CRadius)-(35*CWidth))-2.0,CHeight+5.0,-2.0>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+2.0,CHeight+5.5,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-2.2,CHeight+5.5,-2.2>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+2.2,CHeight+5.8,5>
                                            }
                                       box {<(((2/3)*CRadius)-(35*CWidth))-2.5,CHeight+5.8,-2.5>,
                                            <-(((2/3)*CRadius)-(35*CWidth))+2.5,CHeight+6.5,-2.5>
                                            }
                                       scale <1.2,1,1>
                                       }
                               union { difference { union { cylinder {<0,-2,0>,<0,(-CHeight/2.75)-2,0>,-CRadius+CWidth+0.6 // The Bit At the Base of the Columns
                                                                      texture { White_Texture
                                                                                normal { brick 1
                                                                                         scale 2
                                                                                         }
                                                                                }
                                                                      }
                                                            cylinder {<0,-2,0>,<0,-3,0>,-CRadius+CWidth+0.9}
                                                            cylinder {<0,((-CHeight/2.75)/2)-2.5,0>,<0,((-CHeight/2.75)/2)-3.5,0>,-CRadius+CWidth+0.8}
                                                            union { intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.8}
                                                                                   texture { White_Texture
                                                                                             normal { radial 2 slope_map {[0.0 <1,0>]
                                                                                                                          [0.9 <1,0>]
                                                                                                                          [0.9 <1,-1>]
                                                                                                                          [1.0 <0,-1>]
                                                                                                                          }
                                                                                                      frequency 10
                                                                                                      rotate x*90
                                                                                                      translate <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>
                                                                                                      }
                                                                                             }
                                                                                   }
                                                                    intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2.2*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   plane {-y,0
                                                                                          rotate z*-75
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   plane {y,0
                                                                                          rotate z*-105
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.9}
                                                                                   }
                                                                    rotate y*27
                                                                    }
                                                            union { intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.8}
                                                                                   texture { White_Texture
                                                                                             normal { radial 2 slope_map {[0.0 <1,0>]
                                                                                                                          [0.9 <1,0>]
                                                                                                                          [0.9 <1,-1>]
                                                                                                                          [1.0 <0,-1>]
                                                                                                                          }
                                                                                                      frequency 10
                                                                                                      rotate x*90
                                                                                                      translate <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>
                                                                                                      }
                                                                                             }
                                                                                   }
                                                                    intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2.2*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   plane {-y,0
                                                                                          rotate z*-75
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   plane {y,0
                                                                                          rotate z*-105
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.9}
                                                                                   }
                                                                    rotate y*-27
                                                                    }
                                                            union { intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.8}
                                                                                   texture { White_Texture
                                                                                             normal { radial 2 slope_map {[0.0 <1,0>]
                                                                                                                          [0.9 <1,0>]
                                                                                                                          [0.9 <1,-1>]
                                                                                                                          [1.0 <0,-1>]
                                                                                                                          }
                                                                                                      frequency 10
                                                                                                      rotate x*90
                                                                                                      translate <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1.5>
                                                                                                      }
                                                                                             }
                                                                                   }
                                                                    intersection { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-1>,
                                                                                             <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                             2.3*((-CHeight/2.75)-2)/6
                                                                                             }
                                                                                   plane {-y,0
                                                                                          rotate z*-75
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   plane {y,0
                                                                                          rotate z*-105
                                                                                          translate <0,4*((-CHeight/2.75)-2)/6,0>
                                                                                          }
                                                                                   cylinder {<0,-2,0>,<0,4*((-CHeight/2.75)-2)/6,0>,-CRadius+CWidth+0.9}
                                                                                   }
                                                                    }
                                                             }
                                                    union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,
                                                                      <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                      3*((-CHeight/2.75)-2)/16
                                                                      }
                                                            box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-2>,
                                                                 <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>
                                                                 }
                                                            rotate y*-27
                                                            }
                                                    union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,
                                                                      <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                      3*((-CHeight/2.75)-2)/16
                                                                      }
                                                            box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-2>,
                                                                 <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>
                                                                 }
                                                            rotate y*27
                                                            }
                                                    union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,
                                                                      <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                      3*((-CHeight/2.75)-2)/16
                                                                      }
                                                            box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-2>,
                                                                 <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>
                                                                 }
                                                            }
                                                    }
                                       union { intersection { union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,                    // Doors
                                                                                <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                3*((-CHeight/2.75)-2)/16
                                                                                }
                                                                      box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-8>,
                                                                           <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+8>
                                                                           }
                                                                      rotate y*-27
                                                                      }
                                                              cylinder {<0,0,0>,<0,-20,0>,24.5}//(-CRadius+CWidth+0.6)-1}
                                                              pigment { color rgb<0.7,0.5,0.2>}
                                                              }
                                               intersection { union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,
                                                                                <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                3*((-CHeight/2.75)-2)/16
                                                                                }
                                                                      box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-8>,
                                                                           <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+8>
                                                                           }
                                                                      rotate y*27
                                                                      }
                                                              cylinder {<0,0,0>,<0,-20,0>,24.5}//(-CRadius+CWidth+0.6)-1}
                                                              pigment { color rgb<0.7,0.5,0.2>}
                                                              }
                                               intersection { union { cylinder {<0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth-2>,
                                                                                <0,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+3>,
                                                                                3*((-CHeight/2.75)-2)/16
                                                                                }
                                                                      box {<-3*((-CHeight/2.75)-2)/16,(-CHeight/2.75)-10,CRadius-CWidth-8>,
                                                                           <3*((-CHeight/2.75)-2)/16,4*((-CHeight/2.75)-2)/6,CRadius-CWidth+8>
                                                                           }
                                                                      }
                                                              cylinder {<0,0,0>,<0,-20,0>,24.5}//(-CRadius+CWidth+0.6)-1}
                                                              pigment { color rgb<0.7,0.5,0.2>}
                                                              }
                                               }
                                       union { object { Lamp
                                                        translate <0,((4*((-CHeight/2.75)-2)/6)+(3*((-CHeight/2.75)-2)/16))/2,-(-CRadius+CWidth+0.6)-4/5>
                                                        rotate y*-13.5
                                                        }
                                               object { Lamp
                                                        translate <0,((4*((-CHeight/2.75)-2)/6)+(3*((-CHeight/2.75)-2)/16))/2,-(-CRadius+CWidth+0.6)-4/5>
                                                        rotate y*13.5
                                                        }
                                               object { Potted_Bush
                                                        rotate y*90
                                                        scale <0.35,0.43,0.35>*0.8
                                                        translate <0,((-CHeight/2.75)-2),-(-CRadius+CWidth+0.6)-1.4>
                                                        rotate y*-13.5
                                                        }
                                               object { Potted_Bush
                                                        scale <0.35,0.43,0.35>*0.8
                                                        translate <0,((-CHeight/2.75)-2),-(-CRadius+CWidth+0.6)-1.4>
                                                        rotate y*13.5
                                                        }
                                               }
                                       union {
#declare Count = 0
#while (Count<9)
                                               box {<-1.5,0,-5>,<1.5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*15
                                                    translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                    rotate y*-30
                                                    }
  #declare Count = Count+1
#end
                                               box {<-1.5,0,-5>,<5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*15
                                                    translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                    rotate y*-30
                                                    }
  #declare Count = 0
#while (Count<6)
                                               box {<-1.5,0,-5>,<1.5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*(15-90)
                                                    translate <18,(16-(Count+9))*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3+(2*Count)>
                                                    rotate y*-30
                                                    }
  #declare Count = Count +1
#end
  #declare Count = 0
#while (Count<9)
                                               union { cylinder {<0,((-CHeight/2.75)-2)/16,-0.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 <4.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,((-CHeight/2.75)-2)/16,-4.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 <4.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-4.5>,
                                                                 0.1
                                                                 }
                                                       rotate y*15
                                                       translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                       rotate y*-30
                                                       texture { Black_Lamp}
                                                       }
  #declare Count = Count + 1
#end
  #declare Count = 0
#while (Count<6)
                                               union { cylinder {<0,((-CHeight/2.75)-2)/16,-0.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 <7.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,((-CHeight/2.75)-2)/16,-4.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 <7.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-4.5>,
                                                                 0.1
                                                                 }
                                                       rotate y*(15-90)
                                                       translate <18,(16-(Count+9))*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3+(2*Count)>
                                                       rotate y*-30
                                                       texture { Black_Lamp}
                                                       }
  #declare Count = Count + 1
#end
  #declare Count = 0
                                               texture { White_Texture}
                                               rotate y*30
                                               translate <2,-((16-1)*((-CHeight/2.75)-2)/16),-(-(-CRadius+CWidth+0.6)-3)>
                                               scale <1,0.85,1>
                                               rotate y*-20
                                               translate <-10,((16-1)*((-CHeight/2.75)-2)/16),-(-CRadius+CWidth+0.6)-16>
                                               rotate y*-30
                                               }
                                       texture { White_Texture}
                                       }
                                       union {
#declare Count = 0
#while (Count<9)
                                               box {<-1.5,0,-5>,<1.5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*15
                                                    translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                    rotate y*-30
                                                    }
  #declare Count = Count+1
#end
                                               box {<-1.5,0,-5>,<5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*15
                                                    translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                    rotate y*-30
                                                    }
  #declare Count = 0
#while (Count<6)
                                               box {<-1.5,0,-5>,<1.5,((-CHeight/2.75)-2)/16,0>
                                                    rotate y*(15-90)
                                                    translate <18,(16-(Count+9))*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3+(2*Count)>
                                                    rotate y*-30
                                                    }
  #declare Count = Count +1
#end
  #declare Count = 0
#while (Count<9)
                                               union { cylinder {<0,((-CHeight/2.75)-2)/16,-0.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 <4.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,((-CHeight/2.75)-2)/16,-4.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 <4.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-4.5>,
                                                                 0.1
                                                                 }
                                                       rotate y*15
                                                       translate <(2*Count),(16-Count)*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3>
                                                       rotate y*-30
                                                       texture { Black_Lamp}
                                                       }
  #declare Count = Count + 1
#end
  #declare Count = 0
#while (Count<6)
                                               union { cylinder {<0,((-CHeight/2.75)-2)/16,-0.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-0.5>,
                                                                 <7.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-0.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,((-CHeight/2.75)-2)/16,-4.5>,
                                                                 <0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 0.1
                                                                 }
                                                       cylinder {<0,(((-CHeight/2.75)-2)/16)+3.5,-4.5>,
                                                                 <7.5/3,((((-CHeight/2.75)-2)/16)+3.5)-(1*((-CHeight/2.75)-2)/16),-4.5>,
                                                                 0.1
                                                                 }
                                                       rotate y*(15-90)
                                                       translate <18,(16-(Count+9))*((-CHeight/2.75)-2)/16,-(-CRadius+CWidth+0.6)-3+(2*Count)>
                                                       rotate y*-30
                                                       texture { Black_Lamp}
                                                       }
  #declare Count = Count + 1
#end
  #declare Count = 0
                                               texture { White_Texture}
                                               rotate y*30
                                               translate <2,-((16-1)*((-CHeight/2.75)-2)/16),-(-(-CRadius+CWidth+0.6)-3)>
                                               scale <1,0.85,1>
                                               rotate y*-20
                                               translate <-10,((16-1)*((-CHeight/2.75)-2)/16),-(-CRadius+CWidth+0.6)-16>
                                               rotate y*-30
                                               scale <-1,1,1>
                                               }
                               union { difference { cylinder {<0,-2,0>,<0,CHeight,0>,(2/3)*CRadius}
                                                    box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,0,(2/3)*CRadius>
                                                         // pigment { Red}
                                                         rotate y*((180/5)*1)
                                                         }
                                                    box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,0,(2/3)*CRadius>
                                                         // pigemnt { Red}
                                                         rotate y*((180/5)*-1)
                                                         }
                                                    box {<-1*CWidth,0,-1>,<1*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,0,(2/3)*CRadius>
                                                         // pigment { Red}
                                                         rotate y*((180/5)*0)
                                                         }
                                                    box {<-1*CWidth,0,-1>,<1*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,(CHeight*(17/32))+1.3,(2/3)*CRadius>
                                                         rotate y*((180/5)*0)
                                                         }
                                                    box {<-1*CWidth,0,-1>,<1*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,(CHeight*(17/32))+1.3,(2/3)*CRadius>
                                                         rotate y*((180/5)*1)
                                                         }
                                                    box {<-1*CWidth,0,-1>,<1*CWidth,1*(CHeight*(17/32))/2,5>
                                                         translate <0,(CHeight*(17/32))+1.3,(2/3)*CRadius>
                                                         rotate y*((180/5)*-1)
                                                         }
                                                    }
                                       union { object { Curtains
                                                        translate <0,0,(2/3)*CRadius>
                                                        rotate y*((180/5)*1)
                                                        }
                                               object { Curtains
                                                        translate <0,0,(2/3)*CRadius>
                                                        rotate y*((180/5)*-1)
                                                        }
                                               object { Curtains
                                                        translate <0,0,(2/3)*CRadius>
                                                        rotate y*((180/5)*0)
                                                        }
                                               }
                                       union { union { box {<(-1*CWidth)-0.7,0,-1>,<(-1*CWidth)-0.3,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,0,-1>,<(1*CWidth)+0.7,0.7,2>}
                                                       box {<(1*CWidth)+0.3,0,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,(1*(CHeight*(17/32))/2)+0.7,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+1.2,2>}
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       //pigment { Green}
                                                       rotate y*((180/5)*-1)
                                                       }
                                               union { box {<(-1*CWidth)-0.7,0,-1>,<(-1*CWidth)-0.3,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,0,-1>,<(1*CWidth)+0.7,0.7,2>}
                                                       box {<(1*CWidth)+0.3,0,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,(1*(CHeight*(17/32))/2)+0.7,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+1.2,2>}
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       //pigment { Green}
                                                       rotate y*((180/5)*1)
                                                       }
                                               union { box {<(-1*CWidth)-0.7,0,-1>,<(-1*CWidth)-0.3,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,0,-1>,<(1*CWidth)+0.7,0.7,2>}
                                                       box {<(1*CWidth)+0.3,0,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+0.7,2>}
                                                       box {<(-1*CWidth)-0.7,(1*(CHeight*(17/32))/2)+0.7,-1>,<(1*CWidth)+0.7,(1*(CHeight*(17/32))/2)+1.2,2>}
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       //pigment { Green}
                                                       }
                                               union { box {<(-1*CWidth),0,0>,<CWidth,1*(CHeight*(17/32))/2,1>
                                                            texture { Window_Glass}
                                                            }
                                                       cylinder {<(-1*CWidth),1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(1*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(1*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(2*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(2*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       light_source {<(-1*CWidth)/2,2*(1*(CHeight*(17/32))/2)/3,4>
                                                                     color rgb<650,375,140>/(512+200)
                                                                     fade_power 2
                                                                     fade_distance 8
                                                                     }
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       }
                                               union { box {<(-1*CWidth),0,0>,<CWidth,1*(CHeight*(17/32))/2,1>
                                                            texture { Window_Glass}
                                                            }
                                                       cylinder {<(-1*CWidth),1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(1*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(1*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(2*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(2*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       light_source {<(-1*CWidth)/2,2*(1*(CHeight*(17/32))/2)/3,4>
                                                                     color rgb<600,425,140>/(512+200)
                                                                     fade_power 2
                                                                     fade_distance 8
                                                                     }
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       rotate y*((180/5)*1)
                                                       }
                                               union { box {<(-1*CWidth),0,0>,<CWidth,1*(CHeight*(17/32))/2,1>
                                                            texture { Window_Glass}
                                                            }
                                                       cylinder {<(-1*CWidth),1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,1*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,2*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(-1*CWidth),3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 <CWidth,3*(1*(CHeight*(17/32))/2)/4,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(1*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(1*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       cylinder {<(2*(-2*CWidth)/3)+CWidth,(1*(CHeight*(17/32))/2),0>,
                                                                 <(2*(-2*CWidth)/3)+CWidth,0,0>,
                                                                 0.04
                                                                 }
                                                       light_source {<(1*CWidth)/2,2*(1*(CHeight*(17/32))/2)/3,4>
                                                                     color rgb<700,350,140>/(512+200)
                                                                     fade_power 2
                                                                     fade_distance 8
                                                                     }
                                                       scale WindowScale
                                                       translate <0,0,(2/3)*CRadius>
                                                       rotate y*((180/5)*-1)
                                                       }
                                               union { intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      //translate <2,0,-5>
                                                                      }
                                                       intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      scale <-1,1,1>
                                                                      }
                                                       box {<(-1*CWidth)-1.4,(1*(CHeight*(17/32))/2)+1.2+2,-0.8>,
                                                            <(1*CWidth)+1.4,(1*(CHeight*(17/32))/2)+1.2+2.4,2>
                                                            scale WindowScale
                                                            translate <0,0,(2/3)*CRadius>
                                                            //pigment { Red}
                                                            }
                                                       union { intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              }
                                                               intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              scale <-1,1,1>
                                                                              }
                                                               //pigment { Red}
                                                               }
                                                       }
                                               union { intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      //translate <2,0,-5>
                                                                      }
                                                       intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      scale <-1,1,1>
                                                                      }
                                                       box {<(-1*CWidth)-1.4,(1*(CHeight*(17/32))/2)+1.2+2,-0.8>,
                                                            <(1*CWidth)+1.4,(1*(CHeight*(17/32))/2)+1.2+2.4,2>
                                                            scale WindowScale
                                                            translate <0,0,(2/3)*CRadius>
                                                            //pigment { Red}
                                                            }
                                                       union { intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              }
                                                               intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              scale <-1,1,1>
                                                                              }
                                                               //pigment { Red}
                                                               }
                                                       rotate y*((180/5)*1)
                                                       }
                                               union { intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      //translate <2,0,-5>
                                                                      }
                                                       intersection { cylinder {<0,0,0>,
                                                                                <-0.4,0,0>,
                                                                                1
                                                                                scale <1,3,1>
                                                                                translate <(-1*CWidth)-1,(1*(CHeight*(17/32))/2)+1.2+2,0>
                                                                                scale WindowScale
                                                                                translate <0,0,(2/3)*CRadius>
                                                                                }
                                                                      box {<(-1*CWidth)-1.5,(1*(CHeight*(17/32))/2)+1.2+2-3,-2>,
                                                                           <(-1*CWidth)-0.9,(1*(CHeight*(17/32))/2)+1.2+2,2>
                                                                           scale WindowScale
                                                                           translate <0,0,(2/3)*CRadius>
                                                                           }
                                                                      //pigment { Red}
                                                                      scale <-1,1,1>
                                                                      }
                                                       box {<(-1*CWidth)-1.4,(1*(CHeight*(17/32))/2)+1.2+2,-0.8>,
                                                            <(1*CWidth)+1.4,(1*(CHeight*(17/32))/2)+1.2+2.4,2>
                                                            scale WindowScale
                                                            translate <0,0,(2/3)*CRadius>
                                                            //pigment { Red}
                                                            }
                                                       union { intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              }
                                                               intersection { box {<-(((1*CWidth)+1.8)/(cos(radians(25)))),-0.4,-2>,
                                                                                   <0,-0.2,2>
                                                                                   }
                                                                              plane {<0,0,-1>,0
                                                                                     rotate y*20
                                                                                     translate <0,0,-(((1*CWidth)+2)*(tan(radians(20))))-1>
                                                                                     }
                                                                              rotate z*25
                                                                              scale WindowScale
                                                                              translate <0,(((1*CWidth)+1.8)*(tan(radians(25))))+((1*(CHeight*(17/32))/2)+1.2+2.4),(2/3)*CRadius>
                                                                              scale <-1,1,1>
                                                                              }
                                                               //pigment { Red}
                                                               }
                                                       rotate y*((180/5)*-1)
                                                       }
                                               translate <0,0,-1>
                                               }
                                       union { object { Window2
                                                        rotate y*((180/5)*-1)
                                                        }
                                               object { Window2
                                                        rotate y*((180/5)*1)
                                                        }
                                               object { Window2
                                                        }
                                               }
                                       union {
#while (Count<5)
                                               light_source {<0,(CHeight*(17/32))-0.1,(10/12)*CRadius> color rgb<253,225,140>/(512+200)
                                                             looks_like { sphere {<0,0,0>,0.7
                                                                                  pigment { color rgbf<253,225,140,721>/(255*1.05)}
                                                                                  finish { ambient 0}
                                                                                  no_shadow
                                                                                  }
                                                                          }
                                                             fade_distance -CRadius*(1/8)
                                                             fade_power 2
                                                             //atmosphere off
                                                             rotate y*((180/7)*(Count-2))
                                                             }
  #declare Count = Count + 1
#end
  #declare Count = 0
                                               }
                                       cylinder {<0,CHeight*(17/32),0>,<0,(CHeight*(17/32))+1,0>,CRadius}
                                       }
                               union { object { Window
                                                translate <((2/3)*CRadius),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(8*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(16*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(24*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(32*CWidth),0,-(2/3)*CRadius>
                                                }
                                       scale <1.2,1,1>
                                       }
                               union { object { Window
                                                translate <((2/3)*CRadius),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(8*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(16*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(24*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window
                                                translate <((2/3)*CRadius)-(32*CWidth),0,-(2/3)*CRadius>
                                                }
                                       scale <-1.2,1,1>
                                       }
                               union { object { Window2
                                                translate <((2/3)*CRadius),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(8*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(16*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(24*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(32*CWidth),0,-(2/3)*CRadius>
                                                }
                                       scale <1.2,1,1>
                                       }
                               union { object { Window2
                                                translate <((2/3)*CRadius),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(8*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(16*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(24*CWidth),0,-(2/3)*CRadius>
                                                }
                                       object { Window2
                                                translate <((2/3)*CRadius)-(32*CWidth),0,-(2/3)*CRadius>
                                                }
                                       scale <-1.2,1,1>
                                       }
                               difference { box {<0,-(CHeight/2.75),0>,
                                                 <(((2/3)*CRadius)-(35*CWidth)),CHeight+6.5,-CRadius>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(8*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(16*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(24*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(32*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(8*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(16*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(24*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(32*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            scale <1.2,1,1>
                                            }
                               difference { box {<0,-(CHeight/2.75),0>,
                                                 <(((2/3)*CRadius)-(35*CWidth)),CHeight+6.5,-CRadius>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(8*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(16*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(24*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(32*CWidth),0,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(8*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(16*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(24*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            box {<-1*CWidth,0,-1>,<1.5*CWidth,1*(CHeight*(17/32))/2,5>
                                                 translate <((2/3)*CRadius)-(32*CWidth),(CHeight*(17/32))+1.3,0>
                                                 }
                                            scale <-1.2,1,1>
                                            }
                               union { object { Column
                                                translate <((2/3)*CRadius)-(28*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <((2/3)*CRadius)-(20*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <((2/3)*CRadius)-(12*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <CRadius,0,CWidth/2>
                                                }
                                       scale <1.2,1,1>
                                       }
                               union { object { Column
                                                translate <((2/3)*CRadius)-(28*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <((2/3)*CRadius)-(20*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <((2/3)*CRadius)-(12*CWidth),0,CWidth/2>
                                                }
                                       object { Column
                                                translate <CRadius,0,CWidth/2>
                                                }
                                       scale <-1.2,1,1>
                                       }
                               union {
#declare Count = 1
#while (Count<8)
                                       object { Railings
                                                translate <0,((17/32)*CHeight)+3.5,CRadius>
                                                rotate y*-90
                                                rotate y*((180/8)*Count)
                                                }
  #declare Count = Count + 1
#end
#declare Count = 0
                                       }
                               union { object { Dust2
                                                scale 10
                                                translate <CRadius-(25*CWidth),CHeight+15,(-CRadius/3)>
                                                }
                                       object { Dust2
                                                scale <8,4,8>
                                                rotate x*180
                                                rotate y*180
                                                translate <-(2/3)*CRadius,((17/32)*CHeight)+(0.25*CHeight),(2/3)*CRadius>
                                                }
                                       }
                               union { light_source {<CRadius-(25*CWidth),CHeight+7,2>
                                                     color rgb<248,133,104>/255
                                                     fade_distance CRadius/2
                                                     fade_power 2
                                                     }
                                       light_source {<0,-1.5,-CRadius*2>
                                                     color White
                                                     spotlight
                                                     point_at <0,-1.0,-CRadius*2>
                                                     radius 90
                                                     falloff 90
                                                     tightness 10
                                                     fade_distance CRadius*1.25
                                                     fade_power 2
                                                     }
                                       light_source {(<-1*CWidth,0,-1>+<1.5*CWidth,1*(CHeight*(17/32))/2,5>)/2
                                                     color White
                                                     fade_distance 5
                                                     fade_power 2
                                                     }
                                       light_source {<-(2/3)*CRadius,((17/32)*CHeight)+(0.25*CHeight),(2/3)*CRadius>
                                                     color White
                                                     fade_distance (1/2)*CRadius
                                                     fade_power 2
                                                     }
                                       }
                               texture { White_Texture}
                               translate <0,(CHeight/2.75),0>
                               }

#declare Ship = union { difference { plane {-y,0}
                                     cone {<0,-2,0>,5*-CRadius,
                                           <0,20,>,4.5*-CRadius
                                           }
                                     }
                        cone { <0,0,0>,4*-CRadius,
                               <0,20,0>,4.5-CRadius
                               }
                        intersection { cone {<0,-20,0>,4*-CRadius,
                                             <0,20,>,4.5*-CRadius
                                             }
                                       union { 
#while (Count<8)
                                               union { box {<CRadius,-10,4.5*CRadius>,
                                                            <(1/3)*CRadius,20,0>
                                                            }
                                                       box {<(1/3)*CRadius,0,4.5*CRadius>,
                                                            <-(1/3)*CRadius,20,0>
                                                            }
                                                       box {<-(1/3)*CRadius,-10,4.5*CRadius>,
                                                            <-CRadius,20,0>
                                                            }
                                                       box {<CRadius,-21,4.5*CRadius>,
                                                            <(1/3)*CRadius,20,4*CRadius>
                                                            }
                                                       box {<(1/3)*CRadius,-10,4.5*CRadius>,
                                                            <-(1/3)*CRadius,20,4*CRadius>
                                                            }
                                                       box {<-(1/3)*CRadius,-21,4.5*CRadius>,
                                                            <-CRadius,20,4*CRadius>
                                                            }
                                                       cone {<0,-21,0>,1.5*-CRadius,
                                                             <0,20,>,2*-CRadius
                                                             }
                                                       rotate y*45*Count
                                                       }
  #declare Count = Count + 1
#end
                                               }
                                       scale <1,0.3,1>
                                       }
#declare Count = 0
                        texture { pigment { Gray40
                                            quick_color White
                                            }
                                  normal { bump_map { gif "ShipBump.gif"
                                                      bump_size 10
                                                      interpolate 2
                                                      }
                                  rotate x*90
                                  translate <-0.5,0,-0.5>
                                  scale 10*CRadius
                                           }
                                  }
                        }

// Final Positionings

/*object { Leaf
         rotate x*-20
         }*/

/*object { Sub_Branch
         rotate x*90
         }*/

/*object { Branch
         rotate y*90
         }*/

/*object { Tree1
         //translate <3072,0,768>
         }*/

/*object { Tree
         rotate y*90
         translate <-768,0,1024>
         }*/

object { House_Front}

object { Ship
         scale 0.75
         translate <0,CHeight*3,0>
         scale 1.30
         }

object { AlienFire
         scale CHeight/4
         translate <0,CHeight+20,0>
         }

object { TreeLeft
         scale 1/768
         scale 2*CHeight
         translate <((2/3)*CRadius)-(35*CWidth),-2,-20>
         }

object { TreeLeft
         rotate y*180
         scale 1/768
         scale <2*CHeight,20,2*CHeight>
         translate <((2/3)*CRadius)-(35*CWidth),-5,-20>
         }

object { BaseTree
         rotate y*180
         scale 1/512
         scale 10
         translate <((2/3)*CRadius)-(7*CWidth),-2,-50>
         }

object { BaseTree
         rotate y*180
         scale 1/512
         scale 10
         translate <((2/3)*CRadius)-(7*CWidth),-4,-50>
         }

object { BaseTree
         rotate y*180
         rotate x*180
         scale 1/512
         scale 10
         translate <-(((2/3)*CRadius)-(7*CWidth)),2,-50>
         }

object { BaseTree
         rotate y*360
         rotate x*180
         scale 1/512
         scale 10
         translate <-(((2/3)*CRadius)-(7*CWidth)),3,-50>
         }

object { TreeRight
         scale 1/1280
         scale 1.7*(CHeight+10)
         translate <-(((2/3)*CRadius)-(24*CWidth)),-20,-20>
         }

object { TreeLeft
         rotate y*180
         scale 1/768
         scale <1.5*CHeight,1.7*CHeight,1.5*CHeight>
         translate <-(((2/3)*CRadius)-(40*CWidth)),-10,-20>
         }

//object { Lamp}

//object { Potted_Bush}

// Final Houses

plane {y,-2
       pigment { Gray80}
       }

/*fog { distance 100000
      color rgb<255,122,66>/255
      }*/

camera { location <0,-1.5,-224>
         look_at <0,35,0>
         angle 42
         }

/*camera { location <0,7,-96> // For Window
         look_at <0,7,0>
         angle 30
         translate <((2/3)*CRadius)-(6*CWidth),0,0>
         //rotate y*((180/5)*0.5)
         }*/

/*camera { location <-(((2/3)*CRadius)-(35*CWidth))-2.0,CHeight+5.0,-10.0>
         look_at <-(((2/3)*CRadius)-(35*CWidth))-2.0,CHeight+5.0,-2.0>
         }*/

/*camera { location <0,0,-30> // For Lamp
         look_at <0,0,0>
         }*/

/*camera { location <0,640,-2048> // For Trees
         look_at <0,640,0>
         }*/

//light_source {<-1500,500,-2500>*1 color Gray20}//Gray40}
//light_source {<2500,2500,-2500>*1 color Gray40}//Gray60}
